import { TypeOrmModuleOptions } from "@nestjs/typeorm";
import { join } from "path";
import { DataSource, DataSourceOptions } from "typeorm";

export const dataSourceOptions: DataSourceOptions = {
  type: "mysql",
  host: process.env.DB_HOST || "localhost",
  port: parseInt(process.env.DB_PORT || "3306", 10),
  username: process.env.DB_USERNAME || "mokter",
  password: process.env.DB_PASSWORD || "Amijanina@1998",
  database: process.env.DB_DATABASE || "demo",
  entities: [join(__dirname, "../**/*.entity{.ts,.js}")],
  migrations: [join(__dirname, "../migrations/*{.ts,.js}")],
  migrationsTableName: "typeorm_migrations",
  synchronize: false,
};

export const typeOrmConfig: TypeOrmModuleOptions = {
  ...dataSourceOptions,
};

export const AppDataSource = new DataSource(dataSourceOptions);
