import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToMany,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from "typeorm";
import { Product } from "./product.entity";
import { Stock } from "./stock.entity";
import { SupplierProductSize } from "./supplier-product-size.entity";
import { SupplierProduct } from "./supplier-product.entity";

@Entity("colors")
export class Color {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ unique: true })
  name: string;

  @CreateDateColumn()
  created_at: Date;

  @UpdateDateColumn()
  updated_at: Date;

  @ManyToMany(() => Product, (product) => product.colors)
  products: Product[];

  @OneToMany(() => Stock, (stock) => stock.color)
  stocks: Stock[];

  @OneToMany(
    () => SupplierProductSize,
    (supplierProductSize) => supplierProductSize.color
  )
  supplierProductSizes: SupplierProductSize[];

  @OneToMany(
    () => SupplierProduct,
    (supplierProduct) => supplierProduct.color
  )
  supplierProducts: SupplierProduct[];
}
