import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  OneToMany,
} from "typeorm";
import { Order } from "./order.entity";

@Entity("customers")
export class Customer {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  first_name: string;

  @Column({ unique: true })
  email: string;

  @Column()
  last_name: string;

  @Column({ type: "varchar", length: 32, nullable: true, unique: true })
  phone: string | null;

  @Column({ type: "text", nullable: true })
  address: string | null;

  @CreateDateColumn()
  created_at: Date;

  @UpdateDateColumn()
  updated_at: Date;

  @OneToMany(() => Order, (order) => order.customer)
  orders: Order[];
}
