import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  JoinColumn,
  CreateDateColumn,
  UpdateDateColumn,
} from "typeorm";
import { Order } from "./order.entity";
import { Product } from "./product.entity";
import { Size } from "./size.entity";

@Entity("order_items")
export class OrderItem {
  @PrimaryGeneratedColumn()
  id: number;

  @ManyToOne(() => Order, (order) => order.items, {
    onDelete: "CASCADE",
  })
  @JoinColumn({ name: "order_id" })
  order: Order;

  @ManyToOne(() => Product, (product) => product.orderItems, {
    eager: false,
    onDelete: "RESTRICT",
  })
  @JoinColumn({ name: "product_id" })
  product: Product;

  @Column()
  size_id: number;

  @ManyToOne(() => Size, (size) => size.orderItems, {
    onDelete: "RESTRICT",
  })
  @JoinColumn({ name: "size_id" })
  size: Size;

  @Column({ type: "int" })
  quantity: number;

  @Column({ type: "int", default: 0 })
  returned_quantity: number;

  @Column({ type: "decimal", precision: 12, scale: 2 })
  unit_price: number;

  @Column({ type: "decimal", precision: 12, scale: 2 })
  line_total: number;

  @CreateDateColumn()
  created_at: Date;

  @UpdateDateColumn()
  updated_at: Date;
}
