import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  JoinColumn,
} from "typeorm";
import { OrderReturn } from "./order-return.entity";
import { OrderItem } from "./order-item.entity";

@Entity("order_return_items")
export class OrderReturnItem {
  @PrimaryGeneratedColumn()
  id: number;

  @ManyToOne(() => OrderReturn, (orderReturn) => orderReturn.items, {
    onDelete: "CASCADE",
  })
  @JoinColumn({ name: "order_return_id" })
  orderReturn: OrderReturn;

  @ManyToOne(() => OrderItem, { onDelete: "RESTRICT" })
  @JoinColumn({ name: "order_item_id" })
  orderItem: OrderItem;

  @Column({ type: "int" })
  quantity: number;

  @Column({ type: "decimal", precision: 12, scale: 2 })
  amount: number;
}
