import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  OneToMany,
  JoinColumn,
  CreateDateColumn,
} from "typeorm";
import { Order } from "./order.entity";
import { OrderReturnItem } from "./order-return-item.entity";

@Entity("order_returns")
export class OrderReturn {
  @PrimaryGeneratedColumn()
  id: number;

  @ManyToOne(() => Order, (order) => order.returns, {
    onDelete: "CASCADE",
  })
  @JoinColumn({ name: "order_id" })
  order: Order;

  @Column({ type: "decimal", precision: 12, scale: 2 })
  total_amount: number;

  @Column({ type: "text", nullable: true })
  reason: string | null;

  @CreateDateColumn()
  created_at: Date;

  @OneToMany(() => OrderReturnItem, (item) => item.orderReturn, {
    cascade: ["insert"],
  })
  items: OrderReturnItem[];
}
