import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  OneToMany,
  CreateDateColumn,
  UpdateDateColumn,
  JoinColumn,
} from "typeorm";
import { Customer } from "./customer.entity";
import { OrderItem } from "./order-item.entity";
import { OrderReturn } from "./order-return.entity";

@Entity("orders")
export class Order {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ unique: true })
  order_code: string;

  @ManyToOne(() => Customer, (customer) => customer.orders, {
    nullable: false,
    onDelete: "RESTRICT",
  })
  @JoinColumn({ name: "customer_id" })
  customer: Customer;

  @Column({ type: "datetime" })
  order_date: Date;

  @Column({ default: "pending" })
  status: string;

  @Column({ type: "decimal", precision: 12, scale: 2, default: 0 })
  total_amount: number;

  @Column({ type: "decimal", precision: 12, scale: 2, default: 0 })
  refunded_amount: number;

  @CreateDateColumn()
  created_at: Date;

  @UpdateDateColumn()
  updated_at: Date;

  @OneToMany(() => OrderItem, (orderItem) => orderItem.order, {
    cascade: true,
  })
  items: OrderItem[];

  @OneToMany(() => OrderReturn, (orderReturn) => orderReturn.order)
  returns: OrderReturn[];
}
