import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  OneToMany,
  ManyToOne,
  ManyToMany,
  JoinColumn,
  JoinTable,
} from "typeorm";
import { SupplierProduct } from "./supplier-product.entity";
import { PurchaseOrderItem } from "./purchase-order-item.entity";
import { OrderItem } from "./order-item.entity";
import { Stock } from "./stock.entity";
import { Category } from "./category.entity";
import { Size } from "./size.entity";
import { Color } from "./color.entity";

@Entity("products")
export class Product {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ unique: true })
  product_code: string;

  @Column()
  product_name: string;

  @Column({ type: "text", nullable: true })
  product_color: string;

  @Column({ type: "text", nullable: true })
  description: string;

  @CreateDateColumn()
  created_at: Date;

  @ManyToOne(() => Category, (category) => category.products, {
    nullable: true,
    onDelete: "SET NULL",
  })
  @JoinColumn({ name: "category_id" })
  category?: Category | null;

  @OneToMany(
    () => SupplierProduct,
    (supplierProduct) => supplierProduct.product
  )
  supplierProducts: SupplierProduct[];

  @OneToMany(
    () => PurchaseOrderItem,
    (purchaseOrderItem) => purchaseOrderItem.product
  )
  purchaseOrderItems: PurchaseOrderItem[];

  @OneToMany(() => OrderItem, (orderItem) => orderItem.product)
  orderItems: OrderItem[];

  @OneToMany(() => Stock, (stock) => stock.product)
  stocks: Stock[];

  @ManyToMany(() => Size, (size) => size.products, { eager: false })
  @JoinTable({
    name: "product_sizes",
    joinColumn: { name: "product_id", referencedColumnName: "id" },
    inverseJoinColumn: { name: "size_id", referencedColumnName: "id" },
  })
  sizes: Size[];

  @ManyToMany(() => Color, (color) => color.products, { eager: false })
  @JoinTable({
    name: "product_colors",
    joinColumn: { name: "product_id", referencedColumnName: "id" },
    inverseJoinColumn: { name: "color_id", referencedColumnName: "id" },
  })
  colors: Color[];
}
