import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  JoinColumn,
} from "typeorm";
import { PurchaseOrder } from "./purchase-order.entity";
import { Product } from "./product.entity";
import { Size } from "./size.entity";

@Entity("purchase_order_items")
export class PurchaseOrderItem {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  order_id: number;

  @Column()
  product_id: number;

  @Column()
  size_id: number;

  @ManyToOne(() => Size, (size) => size.purchaseOrderItems, {
    onDelete: "RESTRICT",
  })
  @JoinColumn({ name: "size_id" })
  size: Size;

  @Column()
  quantity: number;

  @Column({ type: "decimal", precision: 10, scale: 2 })
  unit_price: number;

  @Column({ type: "decimal", precision: 10, scale: 2 })
  total: number;

  @ManyToOne(
    () => PurchaseOrder,
    (purchaseOrder) => purchaseOrder.purchaseOrderItems,
  )
  @JoinColumn({ name: "order_id" })
  purchaseOrder: PurchaseOrder;

  @ManyToOne(() => Product, (product) => product.purchaseOrderItems)
  @JoinColumn({ name: "product_id" })
  product: Product;
}
