import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  ManyToOne,
  OneToMany,
  JoinColumn,
} from "typeorm";
import { Supplier } from "./supplier.entity";
import { PurchaseOrderItem } from "./purchase-order-item.entity";

@Entity("purchase_orders")
export class PurchaseOrder {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  supplier_id: number;

  @Column({ type: "date" })
  order_date: Date;

  @Column({ type: "decimal", precision: 10, scale: 2, default: 0.0 })
  total_amount: number;

  @CreateDateColumn()
  created_at: Date;

  @ManyToOne(() => Supplier, (supplier) => supplier.purchaseOrders)
  @JoinColumn({ name: "supplier_id" })
  supplier: Supplier;

  @OneToMany(
    () => PurchaseOrderItem,
    (purchaseOrderItem) => purchaseOrderItem.purchaseOrder,
  )
  purchaseOrderItems: PurchaseOrderItem[];
}
