import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  OneToMany,
  ManyToMany,
} from "typeorm";
import { Stock } from "./stock.entity";
import { OrderItem } from "./order-item.entity";
import { PurchaseOrderItem } from "./purchase-order-item.entity";
import { Product } from "./product.entity";
import { SupplierProductSize } from "./supplier-product-size.entity";

@Entity("sizes")
export class Size {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ unique: true })
  name: string;

  @CreateDateColumn()
  created_at: Date;

  @UpdateDateColumn()
  updated_at: Date;

  @OneToMany(() => Stock, (stock) => stock.size)
  stocks: Stock[];

  @OneToMany(
    () => SupplierProductSize,
    (supplierProductSize) => supplierProductSize.size
  )
  supplierProductSizes: SupplierProductSize[];

  @OneToMany(() => OrderItem, (orderItem) => orderItem.size)
  orderItems: OrderItem[];

  @OneToMany(
    () => PurchaseOrderItem,
    (purchaseOrderItem) => purchaseOrderItem.size
  )
  purchaseOrderItems: PurchaseOrderItem[];

  @ManyToMany(() => Product, (product) => product.sizes)
  products: Product[];
}
