import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  JoinColumn,
  CreateDateColumn,
} from "typeorm";
import { Stock } from "./stock.entity";

export type StockMovementType = "NEW" | "SALE" | "RETURN";

@Entity("stock_movements")
export class StockMovement {
  @PrimaryGeneratedColumn()
  id: number;

  @ManyToOne(() => Stock, (stock) => stock.movements, {
    onDelete: "CASCADE",
  })
  @JoinColumn({ name: "stock_id" })
  stock: Stock;

  @Column({ type: "enum", enum: ["NEW", "SALE", "RETURN"] })
  movement_type: StockMovementType;

  @Column({ type: "int" })
  quantity: number;

  @Column({ type: "varchar", length: 50, nullable: true })
  reference_type: string | null;

  @Column({ type: "int", nullable: true })
  reference_id: number | null;

  @CreateDateColumn()
  created_at: Date;
}
