import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  OneToMany,
  JoinColumn,
  CreateDateColumn,
  UpdateDateColumn,
  Unique,
} from "typeorm";
import { Product } from "./product.entity";
import { StockMovement } from "./stock-movement.entity";
import { Size } from "./size.entity";
import { Color } from "./color.entity";

@Entity("stocks")
@Unique("UQ_stock_product_size_color", ["product", "size", "color"])
export class Stock {
  @PrimaryGeneratedColumn()
  id: number;

  @ManyToOne(() => Product, (product) => product.stocks, {
    onDelete: "CASCADE",
  })
  @JoinColumn({ name: "product_id" })
  product: Product;

  @Column({ name: "size_id" })
  size_id: number;

  @ManyToOne(() => Size, (size) => size.stocks, {
    onDelete: "RESTRICT",
  })
  @JoinColumn({ name: "size_id" })
  size: Size;

  @Column({ type: "int", default: 0 })
  quantity: number;

  @Column({ name: "color_id", nullable: true })
  color_id: number | null;

  @ManyToOne(() => Color, (color) => color.stocks, {
    onDelete: "RESTRICT",
    nullable: true,
  })
  @JoinColumn({ name: "color_id" })
  color: Color | null;

  @CreateDateColumn()
  created_at: Date;

  @UpdateDateColumn()
  updated_at: Date;

  @OneToMany(() => StockMovement, (movement) => movement.stock)
  movements: StockMovement[];
}
