import {
  Column,
  CreateDateColumn,
  Entity,
  JoinColumn,
  ManyToOne,
  PrimaryGeneratedColumn,
} from "typeorm";
import { SupplierProduct } from "./supplier-product.entity";

@Entity("supplier_product_restock_logs")
export class SupplierProductRestockLog {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  supplier_product_id: number;

  @Column()
  quantity: number;

  @Column({ type: "decimal", precision: 10, scale: 2, nullable: true })
  unit_price: number | null;

  @CreateDateColumn({ name: "restocked_at" })
  restocked_at: Date;

  @ManyToOne(
    () => SupplierProduct,
    (supplierProduct) => supplierProduct.restockLogs,
    { onDelete: "CASCADE" }
  )
  @JoinColumn({ name: "supplier_product_id" })
  supplierProduct: SupplierProduct;
}
