import {
  Column,
  Entity,
  JoinColumn,
  ManyToOne,
  PrimaryGeneratedColumn,
} from "typeorm";
import { SupplierProduct } from "./supplier-product.entity";
import { Size } from "./size.entity";
import { Color } from "./color.entity";

@Entity("supplier_product_sizes")
export class SupplierProductSize {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  supplier_product_id: number;

  @Column()
  size_id: number;

  @Column()
  quantity: number;

  @Column({ name: "color_id", nullable: true })
  color_id: number | null;

  @ManyToOne(() => Color, (color) => color.supplierProductSizes, {
    onDelete: "RESTRICT",
    nullable: true,
  })
  @JoinColumn({ name: "color_id" })
  color: Color | null;

  @ManyToOne(
    () => SupplierProduct,
    (supplierProduct) => supplierProduct.sizes,
    { onDelete: "CASCADE" },
  )
  @JoinColumn({ name: "supplier_product_id" })
  supplierProduct: SupplierProduct;

  @ManyToOne(() => Size, (size) => size.supplierProductSizes, {
    onDelete: "RESTRICT",
  })
  @JoinColumn({ name: "size_id" })
  size: Size;
}
