import { ApiProperty, ApiPropertyOptional } from "@nestjs/swagger";
import {
  Column,
  CreateDateColumn,
  Entity,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from "typeorm";

@Entity("users")
export class User {
  @ApiProperty({
    description: "Unique identifier for the user",
    example: 1,
  })
  @PrimaryGeneratedColumn()
  id: number;

  @ApiProperty({
    description: "Full name of the user",
    example: "Jane Doe",
  })
  @Column()
  name: string;

  @ApiProperty({
    description: "Unique email address associated with the user",
    example: "jane.doe@example.com",
  })
  @Column({ unique: true })
  email: string;

  @ApiPropertyOptional({
    description: "Contact phone number",
    example: "+8801712345678",
  })
  @Column({ nullable: true })
  phone?: string;

  @ApiProperty({
    description: "Active status flag: 1 for active users, 0 for inactive users",
    example: 1,
    enum: [0, 1],
    default: 1,
  })
  @Column({ type: "tinyint", default: 1 })
  status: number;

  @ApiProperty({
    description: "Hashed password for authentication",
    example: "$2a$10$examplehashedpassword",
  })
  @Column()
  password: string;

  @ApiProperty({
    description: "Timestamp in ISO format indicating when the user was created",
    example: "2024-01-15T09:30:00.000Z",
  })
  @CreateDateColumn({ name: "created_at" })
  createdAt: Date;

  @ApiProperty({
    description: "Timestamp in ISO format indicating the last update",
    example: "2024-02-01T12:00:00.000Z",
  })
  @UpdateDateColumn({ name: "updated_at" })
  updatedAt: Date;
}
