import { ApiProperty, ApiPropertyOptional } from "@nestjs/swagger";
import {
  IsArray,
  IsInt,
  IsNotEmpty,
  IsOptional,
  IsPositive,
  IsString,
  ValidateNested,
} from "class-validator";
import { Type } from "class-transformer";

export class CreateOrderReturnItemDto {
  @ApiProperty({ description: "Order item identifier", example: 12 })
  @Type(() => Number)
  @IsInt()
  @IsPositive()
  orderItemId: number;

  @ApiProperty({ description: "Quantity being returned", example: 1 })
  @Type(() => Number)
  @IsInt()
  @IsPositive()
  quantity: number;
}

export class CreateOrderReturnDto {
  @ApiProperty({
    description: "Return items for this request",
    type: [CreateOrderReturnItemDto],
  })
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => CreateOrderReturnItemDto)
  items: CreateOrderReturnItemDto[];

  @ApiPropertyOptional({
    description: "Reason for return",
    example: "Size mismatch",
  })
  @IsOptional()
  @IsString()
  @IsNotEmpty()
  reason?: string;
}
