import { ApiProperty, ApiPropertyOptional } from "@nestjs/swagger";
import {
  IsArray,
  IsDateString,
  IsInt,
  IsOptional,
  IsPositive,
  ValidateNested,
} from "class-validator";
import { Type } from "class-transformer";

export class CreateOrderItemDto {
  @ApiProperty({ description: "Product identifier", example: 1 })
  @Type(() => Number)
  @IsInt()
  @IsPositive()
  productId: number;

  @ApiProperty({ description: "Product size identifier", example: 7 })
  @Type(() => Number)
  @IsInt()
  @IsPositive()
  sizeId: number;

  @ApiProperty({ description: "Quantity ordered", example: 2 })
  @Type(() => Number)
  @IsInt()
  @IsPositive()
  quantity: number;

  @ApiProperty({ description: "Unit price at order time", example: 4800.5 })
  @Type(() => Number)
  @IsPositive()
  unitPrice: number;
}

export class CreateOrderDto {
  @ApiProperty({ description: "Customer identifier", example: 5 })
  @Type(() => Number)
  @IsInt()
  @IsPositive()
  customerId: number;

  @ApiPropertyOptional({
    description: "Order date in ISO format",
    example: "2025-01-15T10:30:00.000Z",
  })
  @IsOptional()
  @IsDateString()
  orderDate?: string;

  @ApiProperty({
    description: "Order line items",
    type: [CreateOrderItemDto],
  })
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => CreateOrderItemDto)
  items: CreateOrderItemDto[];
}
