import { ApiProperty } from "@nestjs/swagger";
import { IsIn, IsNotEmpty, IsString } from "class-validator";

export class UpdateOrderStatusDto {
  @ApiProperty({
    description: "Updated order status",
    example: "completed",
    enum: ["pending", "confirmed", "completed", "cancelled"],
  })
  @IsString()
  @IsNotEmpty()
  @IsIn(["pending", "confirmed", "completed", "cancelled"])
  status: string;
}
