import { Module } from "@nestjs/common";
import { TypeOrmModule } from "@nestjs/typeorm";
import { Order } from "../entities/order.entity";
import { OrderItem } from "../entities/order-item.entity";
import { OrderReturn } from "../entities/order-return.entity";
import { OrderReturnItem } from "../entities/order-return-item.entity";
import { Customer } from "../entities/customer.entity";
import { Product } from "../entities/product.entity";
import { OrderService } from "./order.service";
import { OrderController } from "./order.controller";
import { StockModule } from "../stock/stock.module";
import { Size } from "../entities/size.entity";

@Module({
  imports: [
    TypeOrmModule.forFeature([
      Order,
      OrderItem,
      OrderReturn,
      OrderReturnItem,
      Customer,
      Product,
      Size,
    ]),
    StockModule,
  ],
  controllers: [OrderController],
  providers: [OrderService],
  exports: [OrderService],
})
export class OrderModule {}
