import {
  IsString,
  IsNotEmpty,
  IsOptional,
  IsInt,
  Min,
  IsArray,
  ArrayMinSize,
  IsPositive,
} from "class-validator";
import { ApiProperty, ApiPropertyOptional } from "@nestjs/swagger";
import { Type } from "class-transformer";

export class CreateProductDto {
  @ApiProperty({
    description: "The code of the product",
    example: "LW-001",
  })
  @IsString()
  @IsNotEmpty()
  product_code: string;

  @ApiProperty({
    description: "The name of the product",
    example: "Leather Wallet",
  })
  @IsString()
  @IsNotEmpty()
  product_name: string;

  @ApiProperty({
    description: "The color of the product",
    example: "Black,Goldren",
  })
  @IsString()
  @IsNotEmpty()
  product_color: string;

  @ApiProperty({
    description: "Identifiers of the sizes available for this product",
    example: [1, 2, 3],
    type: [Number],
  })
  @IsArray()
  @ArrayMinSize(1)
  @Type(() => Number)
  @IsInt({ each: true })
  @IsPositive({ each: true })
  sizeIds: number[];

  @ApiProperty({
    description: "The description of the product",
    example: "A stylish leather wallet with multiple card slots",
    required: false,
  })
  @IsString()
  @IsOptional()
  description?: string;

  @ApiPropertyOptional({
    description: "Identifiers of the colors available for this product",
    example: [4, 7],
    type: [Number],
  })
  @IsArray()
  @IsInt({ each: true })
  @IsPositive({ each: true })
  @IsOptional()
  colorIds?: number[];

  @ApiPropertyOptional({
    description: "Identifier of the category this product belongs to",
    example: 2,
  })
  @IsInt()
  @Min(1)
  @IsOptional()
  categoryId?: number | null;
}
