import { Module } from "@nestjs/common";
import { TypeOrmModule } from "@nestjs/typeorm";
import { Product } from "../entities/product.entity";
import { ProductService } from "./product.service";
import { ProductController } from "./product.controller";
import { Category } from "../entities/category.entity";
import { Size } from "../entities/size.entity";
import { Color } from "../entities/color.entity";

@Module({
  imports: [TypeOrmModule.forFeature([Product, Category, Size, Color])],
  providers: [ProductService],
  controllers: [ProductController],
  exports: [ProductService],
})
export class ProductModule {}
