import { Type } from "class-transformer";
import {
  IsNotEmpty,
  IsNumber,
  IsPositive,
  IsDateString,
  ValidateNested,
  ArrayMinSize,
  IsInt,
} from "class-validator";

export class CreatePurchaseOrderItemDto {
  @IsNumber()
  @IsPositive()
  @IsNotEmpty()
  product_id: number;

  @IsInt()
  @IsPositive()
  size_id: number;

  @IsNumber()
  @IsPositive()
  @IsNotEmpty()
  quantity: number;

  @IsNumber()
  @IsPositive()
  @IsNotEmpty()
  unit_price: number;
}

export class CreatePurchaseOrderDto {
  @IsNumber()
  @IsPositive()
  @IsNotEmpty()
  supplier_id: number;

  @IsDateString()
  @IsNotEmpty()
  order_date: string;

  @ArrayMinSize(1)
  @ValidateNested({ each: true })
  @Type(() => CreatePurchaseOrderItemDto)
  items: CreatePurchaseOrderItemDto[];
}
