import { PartialType } from "@nestjs/mapped-types";
import {
  CreatePurchaseOrderDto,
  CreatePurchaseOrderItemDto,
} from "./create-purchase-order.dto";
import {
  IsNumber,
  IsPositive,
  IsOptional,
} from "class-validator";

export class UpdatePurchaseOrderItemDto extends PartialType(
  CreatePurchaseOrderItemDto,
) {
  @IsNumber()
  @IsPositive()
  @IsOptional()
  id?: number; // Assuming items can be updated by their ID

  @IsNumber()
  @IsPositive()
  @IsOptional()
  product_id?: number;

  @IsNumber()
  @IsPositive()
  @IsOptional()
  size_id?: number;

  @IsNumber()
  @IsPositive()
  @IsOptional()
  unit_price?: number;
}

export class UpdatePurchaseOrderDto extends PartialType(
  CreatePurchaseOrderDto,
) {}
