import {
  Controller,
  Get,
  Post,
  Body,
  Param,
  Put,
  Delete,
  HttpCode,
  HttpStatus,
} from "@nestjs/common";
import { PurchaseOrderService } from "./purchase-order.service";
import { CreatePurchaseOrderDto } from "./dto/create-purchase-order.dto";
import { UpdatePurchaseOrderDto } from "./dto/update-purchase-order.dto";

@Controller("api/orders")
export class PurchaseOrderController {
  constructor(private readonly purchaseOrderService: PurchaseOrderService) {}

  @Post()
  @HttpCode(HttpStatus.CREATED)
  create(@Body() createPurchaseOrderDto: CreatePurchaseOrderDto) {
    return this.purchaseOrderService.createPurchaseOrder(
      createPurchaseOrderDto,
    );
  }

  @Get()
  findAll() {
    return this.purchaseOrderService.findAllPurchaseOrders();
  }

  @Get(":id")
  findOne(@Param("id") id: string) {
    return this.purchaseOrderService.getPurchaseOrderById(+id);
  }

  @Get("/supplier/:supplierId")
  findBySupplier(@Param("supplierId") supplierId: string) {
    return this.purchaseOrderService.findPurchaseOrdersBySupplier(+supplierId);
  }

  @Put(":id")
  update(
    @Param("id") id: string,
    @Body() updatePurchaseOrderDto: UpdatePurchaseOrderDto,
  ) {
    return this.purchaseOrderService.updatePurchaseOrder(
      +id,
      updatePurchaseOrderDto,
    );
  }

  @Delete(":id")
  @HttpCode(HttpStatus.NO_CONTENT)
  remove(@Param("id") id: string) {
    return this.purchaseOrderService.deletePurchaseOrder(+id);
  }
}
