import { Module } from "@nestjs/common";
import { TypeOrmModule } from "@nestjs/typeorm";
import { PurchaseOrderService } from "./purchase-order.service";
import { PurchaseOrderController } from "./purchase-order.controller";
import { PurchaseOrder } from "../entities/purchase-order.entity";
import { PurchaseOrderItem } from "../entities/purchase-order-item.entity";
import { SupplierModule } from "../supplier/supplier.module";
import { ProductModule } from "../product/product.module";
import { Supplier } from "../entities/supplier.entity";
import { Product } from "../entities/product.entity";
import { StockModule } from "../stock/stock.module";
import { Size } from "../entities/size.entity";

@Module({
  imports: [
    TypeOrmModule.forFeature([
      PurchaseOrder,
      PurchaseOrderItem,
      Supplier,
      Product,
      Size,
    ]),
    SupplierModule,
    ProductModule,
    StockModule,
  ],
  providers: [PurchaseOrderService],
  controllers: [PurchaseOrderController],
  exports: [PurchaseOrderService],
})
export class PurchaseOrderModule {}
