import { ApiProperty } from "@nestjs/swagger";
import { IsNotEmpty, IsString, MaxLength } from "class-validator";

export class CreateSizeDto {
  @ApiProperty({
    description: "Unique label describing the size",
    example: "XL",
  })
  @IsString()
  @IsNotEmpty()
  @MaxLength(50)
  name: string;
}

