import { ApiProperty, ApiPropertyOptional } from "@nestjs/swagger";
import { IsInt, IsOptional, IsPositive, IsString } from "class-validator";

export class CreateStockDto {
  @ApiProperty({ description: "Product identifier", example: 1 })
  @IsInt()
  @IsPositive()
  productId: number;

  @ApiProperty({ description: "Size identifier", example: 3 })
  @IsInt()
  @IsPositive()
  sizeId: number;

  @ApiPropertyOptional({
    description: "Color identifier for the stock entry",
    example: 4,
  })
  @IsOptional()
  @IsInt()
  @IsPositive()
  colorId?: number;

  @ApiProperty({ description: "Quantity to add", example: 25 })
  @IsInt()
  @IsPositive()
  quantity: number;

  @ApiPropertyOptional({
    description: "Source of stock addition",
    example: "MANUAL_ADJUSTMENT",
  })
  @IsOptional()
  @IsString()
  referenceType?: string;

  @ApiPropertyOptional({
    description: "Reference record identifier",
    example: 1001,
  })
  @IsOptional()
  @IsInt()
  referenceId?: number;
}
