import { ApiPropertyOptional } from "@nestjs/swagger";
import { IsDateString, IsOptional } from "class-validator";

export class StockReportQueryDto {
  @ApiPropertyOptional({
    description: "Start date (inclusive) in YYYY-MM-DD format",
    example: "2024-01-01",
  })
  @IsOptional()
  @IsDateString()
  startDate?: string;

  @ApiPropertyOptional({
    description:
      "End date (inclusive) in YYYY-MM-DD format. Internally treated as the end of the provided day.",
    example: "2024-01-31",
  })
  @IsOptional()
  @IsDateString()
  endDate?: string;
}
