import { Module } from "@nestjs/common";
import { TypeOrmModule } from "@nestjs/typeorm";
import { Stock } from "../entities/stock.entity";
import { StockMovement } from "../entities/stock-movement.entity";
import { Product } from "../entities/product.entity";
import { StockService } from "./stock.service";
import { StockController } from "./stock.controller";
import { Size } from "../entities/size.entity";
import { Color } from "../entities/color.entity";
import { SupplierProduct } from "../entities/supplier-product.entity";

@Module({
  imports: [
    TypeOrmModule.forFeature([
      Stock,
      StockMovement,
      Product,
      Size,
      Color,
      SupplierProduct,
    ]),
  ],
  controllers: [StockController],
  providers: [StockService],
  exports: [StockService],
})
export class StockModule {}
