import {
  IsArray,
  IsInt,
  IsNumber,
  IsPositive,
  ValidateNested,
  IsOptional,
} from "class-validator";
import { Type } from "class-transformer";
import { CreateSupplierProductDto } from "./create-supplier-product.dto";
import { ApiProperty } from "@nestjs/swagger";

export class CreateBulkSupplierProductDto {
  @ApiProperty({ description: "The ID of the supplier", example: 1 })
  @IsInt()
  supplier_id: number;

  @ApiProperty({
    description: "An array of products to assign to the supplier",
    type: [CreateSupplierProductDto],
  })
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => CreateSupplierProductDto)
  products: CreateSupplierProductDto[];

  @ApiProperty({ description: "The quantity of the products", example: 10 })
  @IsInt()
  @IsOptional()
  quantity?: number;

  @ApiProperty({
    description: "The unit price of the products",
    example: 99.99,
  })
  @IsNumber()
  @IsPositive()
  @IsOptional()
  unit_price?: number;
}
