import { ApiPropertyOptional } from "@nestjs/swagger";
import { IsNumberString, IsOptional } from "class-validator";
import { PaginationDto } from "../../common/dto/pagination.dto";

export class SupplierProductListQueryDto extends PaginationDto {
  @ApiPropertyOptional({
    description: "Filter by supplier identifier",
    example: "12",
  })
  @IsOptional()
  @IsNumberString()
  supplierId?: string;
}
