import { Module } from "@nestjs/common";
import { TypeOrmModule } from "@nestjs/typeorm";
import { SupplierProduct } from "../entities/supplier-product.entity";
import { SupplierProductService } from "./supplier-product.service";
import { SupplierProductController } from "./supplier-product.controller";
import { Supplier } from "../entities/supplier.entity";
import { Product } from "../entities/product.entity";
import { SupplierProductRestockLog } from "../entities/supplier-product-restock-log.entity";
import { StockModule } from "../stock/stock.module";
import { Size } from "../entities/size.entity";
import { SupplierProductSize } from "../entities/supplier-product-size.entity";
import { Color } from "../entities/color.entity";

@Module({
  imports: [
    TypeOrmModule.forFeature([
      SupplierProduct,
      Supplier,
      Product,
      SupplierProductRestockLog,
      Size,
      SupplierProductSize,
      Color,
    ]),
    StockModule,
  ],
  providers: [SupplierProductService],
  controllers: [SupplierProductController],
  exports: [SupplierProductService],
})
export class SupplierProductModule {}
