import { ApiProperty } from "@nestjs/swagger";
import {
  IsString,
  IsNotEmpty,
  IsOptional,
  IsEmail,
  IsPhoneNumber,
} from "class-validator";

export class CreateSupplierDto {
  @ApiProperty({ description: "The name of the supplier" })
  @IsString()
  @IsNotEmpty()
  name: string;

  @ApiProperty({ description: "The email of the supplier" })
  @IsEmail()
  @IsNotEmpty()
  email: string;

  @ApiProperty({ description: "The address of the supplier", required: false })
  @IsString()
  @IsOptional()
  address: string;

  @ApiProperty({ description: "The phone number of the supplier" })
  @IsString()
  @IsNotEmpty()
  phone: string;
}
